<?php
header("Content-Type: image/svg+xml");

// Кэшировать 30 дней (2592000 секунд)
header("Cache-Control: public, max-age=2592000");
header("Expires: " . gmdate("D, d M Y H:i:s", time() + 2592000) . " GMT");

// Получаем имя домена
$domainName = explode('.', $_SERVER['HTTP_HOST'])[0];
$char = strtoupper(substr($domainName, 0, 1));
$hash = crc32($domainName);
$color = "#" . substr(md5($hash), 0, 6);

// Генерация SVG
echo <<<SVG
<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64">
  <rect width="100%" height="100%" fill="$color"/>
  <text x="50%" y="55%" dominant-baseline="middle" text-anchor="middle"
        font-size="40" fill="#fff" font-family="Arial, sans-serif">$char</text>
</svg>
SVG;
